// AcMapOrclApiTestImportDlg.cpp : implementation file
//
///////////////////////////////////////////////////////////////////////////////
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
//	Hugues Wisniewski, June 2001
//
// DESCRIPTION:
// 	Implementation of class AcMapOrclApiTestImportDlg

#include "stdafx.h"
#include "AcMapOrclApiTestImportDlg.h"
#include "AcMapOrclApiTestConnectDlg.h"
#include "AcMapOrclApiTestLoadQueryDlg.h"
#include "AcMapOrclApiTestDisplayTextDlg.h"
#include "AcMapOrclApiTestViewSqlDlg.h"
#include "AcMapOracleConnection.h"
#include "AcMapOracleQuery.h"
#include "AcMapOracleImport.h"
#include "AcMapOrclApiTestTools.h"
#include "AcMapOrclApiTestDescribeTableDlg.h"
#include <tchar.h>					//for _tcsupr
#include <vector>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AcMapOrclApiTestImportDlg dialog


//******************************************************************************************
AcMapOrclApiTestImportDlg::AcMapOrclApiTestImportDlg(CWnd* pParent /*=NULL*/)
	: CDialog(AcMapOrclApiTestImportDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(AcMapOrclApiTestImportDlg)
	m_strEditWhereClause = _T("");
	m_nIdConditionSample = -1;
	m_strSelectFromWhere = _T("");
	m_strServiceSchema = _T("");
	m_strTableName = _T("");
	//}}AFX_DATA_INIT
}


//******************************************************************************************
void AcMapOrclApiTestImportDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AcMapOrclApiTestImportDlg)
	DDX_Control(pDX, IDC_LIST_CONDITION_SAMPLES, m_listConditionSamples);
	DDX_Control(pDX, IDC_EDIT_WHERE_CLAUSE, m_editWhereClause);
	DDX_Text(pDX, IDC_EDIT_WHERE_CLAUSE, m_strEditWhereClause);
	DDX_LBIndex(pDX, IDC_LIST_CONDITION_SAMPLES, m_nIdConditionSample);
	DDX_Text(pDX, IDC_STATIC_SELECT_FROM, m_strSelectFromWhere);
	DDX_Text(pDX, IDC_STATIC_SERVICE_SCHEMA, m_strServiceSchema);
	DDX_Text(pDX, IDC_EDIT_TABLENAME, m_strTableName);
	//}}AFX_DATA_MAP
}


//******************************************************************************************
BEGIN_MESSAGE_MAP(AcMapOrclApiTestImportDlg, CDialog)
	//{{AFX_MSG_MAP(AcMapOrclApiTestImportDlg)
	ON_BN_CLICKED(IDC_BTN_CONNECT, OnBtnConnect)
	ON_BN_CLICKED(IDC_BTN_LIST_OD, OnBtnListOd)
	ON_BN_CLICKED(IDC_BTN_LOAD_QUERY, OnBtnLoadQuery)
	ON_BN_CLICKED(IDC_BTN_SAVE_QUERY, OnBtnSaveQuery)
	ON_BN_CLICKED(IDC_BTN_VIEW_SQL, OnBtnViewSql)
	ON_LBN_SELCHANGE(IDC_LIST_CONDITION_SAMPLES, OnSelchangeListOdCondition)
	ON_BN_CLICKED(IDC_BTN_DESCRIBE_OD_TABLE, OnBtnDescribeOdTable)
	ON_BN_CLICKED(IDC_BTN_BLOCKS, OnBtnBlocks)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AcMapOrclApiTestImportDlg message handlers

//******************************************************************************************
BOOL AcMapOrclApiTestImportDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	//read all the samples and fill local string vectors
	if (!AcMapOrclApiTestTools::ReadAllSampleSqlWhereClauses(
		m_vectSqlWhereClauses,
		m_vectSqlWhereClausesTitles))
	{
		EndDialog(IDCANCEL);
		return false;
	}

	m_editWhereClause.SetTabStops(10);

	//fill the list box with sample titles
	for (int i=0; i<m_vectSqlWhereClausesTitles.size(); i++)
	{
		m_listConditionSamples.AddString((const char*)m_vectSqlWhereClausesTitles[i]);
	}

	//init from current query if it exists
	if (AcMapOracleGetConnection()->IsConnected())
	{
		AcMapOracleQuery query(*AcMapOracleGetConnection());
		query.InitWithCurrent();
		std::string strQuery;
		strQuery=query.ConvertToSqlString();
		//we need to extract the where clause
		int nPosWhere=strQuery.find("where ");
		//if no where clause there is no current query
		if (std::string::npos==nPosWhere)
		{
			m_nIdConditionSample=0;
		}
		else
		{
			m_strEditWhereClause=strQuery.substr(nPosWhere+6).c_str();
			m_nIdConditionSample=m_vectSqlWhereClausesTitles.size()-1;
		}
	}
	else
	{
		m_nIdConditionSample=0;
	}


	UpdateServiceSchema();
	UpdateControls();
	UpdateData(false);

	//if not initialized with current query because no current query
	if (0==m_nIdConditionSample)
	{
		OnSelchangeListOdCondition();
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//******************************************************************************************
void AcMapOrclApiTestImportDlg::UpdateServiceSchema()
{
	AcMapOracleConnection *pConnection=AcMapOracleGetConnection();

	if (pConnection->IsConnected())
	{
		m_strServiceSchema.Format(
			"Service: %s\nSchema: %s",
			pConnection->Service(),
			pConnection->UserName());
		m_strSelectFromWhere.Format(
			"select * \nfrom %s.ADMPENTITIES Table0\nwhere",
			pConnection->UserName());
	}
	else
	{
		m_strServiceSchema="Not connected to Oracle";
		m_strEditWhereClause="";
		m_strSelectFromWhere="select * \nfrom schema.ADMPENTITIES Table0\nwhere";
	}
}

//******************************************************************************************
void AcMapOrclApiTestImportDlg::UpdateControls()
{
	AcMapOracleConnection *pConnection=AcMapOracleGetConnection();

	if (pConnection->IsConnected())
	{
		GetDlgItem(IDC_STATIC_CONDITION_SAMPLES)->EnableWindow(true);
		GetDlgItem(IDC_LIST_CONDITION_SAMPLES)->EnableWindow(true);
		GetDlgItem(IDC_STATIC_WHERE_CLAUSE)->EnableWindow(true);
		GetDlgItem(IDC_STATIC_SELECT_FROM)->EnableWindow(true);
		GetDlgItem(IDC_EDIT_WHERE_CLAUSE)->EnableWindow(true);
		GetDlgItem(IDC_STATIC_IMPORT_SETTINGS)->EnableWindow(true);
		GetDlgItem(IDC_BTN_SAVE_QUERY)->EnableWindow(true);
		GetDlgItem(IDC_BTN_LOAD_QUERY)->EnableWindow(true);
		GetDlgItem(IDOK)->EnableWindow(true);
		GetDlgItem(IDC_BTN_LIST_OD)->EnableWindow(true);
		GetDlgItem(IDC_BTN_VIEW_SQL)->EnableWindow(true);
		GetDlgItem(IDC_BTN_DESCRIBE_OD_TABLE)->EnableWindow(true);
		GetDlgItem(IDC_BTN_BLOCKS)->EnableWindow(true);
		GetDlgItem(IDC_EDIT_TABLENAME)->EnableWindow(true);
	}
	else
	{
		GetDlgItem(IDC_STATIC_CONDITION_SAMPLES)->EnableWindow(false);
		GetDlgItem(IDC_LIST_CONDITION_SAMPLES)->EnableWindow(false);
		GetDlgItem(IDC_STATIC_WHERE_CLAUSE)->EnableWindow(false);
		GetDlgItem(IDC_EDIT_WHERE_CLAUSE)->EnableWindow(false);
		GetDlgItem(IDC_STATIC_SELECT_FROM)->EnableWindow(false);
		GetDlgItem(IDC_STATIC_IMPORT_SETTINGS)->EnableWindow(false);
		GetDlgItem(IDC_BTN_SAVE_QUERY)->EnableWindow(false);
		GetDlgItem(IDC_BTN_LOAD_QUERY)->EnableWindow(false);
		GetDlgItem(IDOK)->EnableWindow(false);
		GetDlgItem(IDC_BTN_LIST_OD)->EnableWindow(false);
		GetDlgItem(IDC_BTN_VIEW_SQL)->EnableWindow(false);
		GetDlgItem(IDC_BTN_DESCRIBE_OD_TABLE)->EnableWindow(false);
		GetDlgItem(IDC_BTN_BLOCKS)->EnableWindow(false);
		GetDlgItem(IDC_EDIT_TABLENAME)->EnableWindow(false);
	}
}

//******************************************************************************************
void AcMapOrclApiTestImportDlg::OnBtnConnect() 
{
	AcMapOrclApiTestConnectDlg Dlg;
	Dlg.DoModal();

	UpdateServiceSchema();
	UpdateControls();
	UpdateData(false);

	OnSelchangeListOdCondition();
}

//******************************************************************************************
void AcMapOrclApiTestImportDlg::OnBtnListOd() 
{
	std::string strListValues;
	std::vector<std::string> vectOdTableNames;

	if (!AcMapOrclApiTestTools::GetListStringValuesFromTableColumn(
		"ADMPODDEFINITIONS",
		"OBJECTDATATABLENAME",
		vectOdTableNames))
	{
		return;
	}

	if (0==vectOdTableNames.size())
	{
		AfxMessageBox("There is no Object Data in this schema");
		return;
	}

	for (int i=0; i<vectOdTableNames.size(); i++)
	{
		std::string strPhysicalTableName;

		strListValues+=vectOdTableNames[i];
		strListValues+="\t";
		strPhysicalTableName=vectOdTableNames[i];
		strListValues+="ADMPOD";
		strListValues+=_tcsupr(const_cast<char *>(strPhysicalTableName.c_str()));
		strListValues+="\r\n";
	}

	AcMapOrclApiTestDisplayTextDlg Dlg(
		"Object Data Types",
		"Object data name / Corresponding table name",
		strListValues);
	Dlg.DoModal();
}

//******************************************************************************************
void AcMapOrclApiTestImportDlg::OnBtnLoadQuery() 
{
	AcMapOracleQuery query(*AcMapOracleGetConnection());
	AcMapOrclApiTestLoadQueryDlg Dlg;
	if (IDOK==Dlg.DoModal())
	{
		if (!query.Load((const char*)Dlg.m_strQueryName))
		{
			AfxMessageBox("Problem when reading the query");
			return;
		}

		std::string strQuery;
		strQuery=query.ConvertToSqlString();

		//we need to extract the where clause
		int nPosWhere=strQuery.find("where ");
		if (std::string::npos==nPosWhere)
		{
			AfxMessageBox("Invalid query");
			return;
		}
		m_strEditWhereClause=strQuery.substr(nPosWhere+6).c_str();
		m_nIdConditionSample=m_vectSqlWhereClausesTitles.size()-1;
		GetDlgItem(IDC_STATIC_WHERE_CLAUSE)->EnableWindow(true);
		GetDlgItem(IDC_EDIT_WHERE_CLAUSE)->EnableWindow(true);
		GetDlgItem(IDC_STATIC_SELECT_FROM)->EnableWindow(true);
		UpdateData(false);
	}
}

//******************************************************************************************
void AcMapOrclApiTestImportDlg::OnBtnSaveQuery() 
{
	UpdateData(true);

	if (m_strEditWhereClause.IsEmpty())
	{
		AfxMessageBox("Where clause not defined yet");
		return;
	}

	AcMapOracleQuery query(*AcMapOracleGetConnection());
	query.Init((const char*)m_strEditWhereClause);

	AcMapOrclApiTestDisplayTextDlg Dlg(
		"Save the query",
		"Query Name",
		"");
	if (IDOK==Dlg.DoModal())
	{
		if (!query.Save((const char*)Dlg.m_strText))
		{
			AfxMessageBox("Problem when saving the query");
		}
	}
}

//******************************************************************************************
void AcMapOrclApiTestImportDlg::OnBtnViewSql() 
{
	UpdateData(true);

	if (m_strEditWhereClause.IsEmpty())
	{
		AfxMessageBox("Where clause not defined yet");
		return;
	}

	AcMapOracleQuery query(*AcMapOracleGetConnection());
	query.Init((const char*)m_strEditWhereClause);

	AcMapOrclApiTestViewSqlDlg Dlg(query.ConvertToSqlString());
	Dlg.DoModal();
}

//******************************************************************************************
void AcMapOrclApiTestImportDlg::OnSelchangeListOdCondition() 
{
	UpdateData(true);	
	m_strEditWhereClause=m_vectSqlWhereClauses[m_nIdConditionSample];
	UpdateData(false);
}

//******************************************************************************************
void AcMapOrclApiTestImportDlg::OnOK() 
{
	UpdateData(true);

	if (m_strEditWhereClause.IsEmpty())
	{
		AfxMessageBox("Where clause not defined yet");
		return;
	}

	AcMapOracleQuery query(*AcMapOracleGetConnection());
	query.Init((const char*)m_strEditWhereClause);

	bool bEditMode=false;
	AcMapOracleImport import(*AcMapOracleGetConnection());
	BeginWaitCursor();
	if (!import.Import(query, bEditMode))
	{
		EndWaitCursor();
		AfxMessageBox("The execution of the query failed");
		return;
	}
	EndWaitCursor();
	
	CDialog::OnOK();
}


//******************************************************************************************
void AcMapOrclApiTestImportDlg::OnBtnDescribeOdTable() 
{
	UpdateData(true);
	AcMapOrclApiTestDescribeTableDlg Dlg(m_strTableName, this);
	Dlg.DoModal();
}

//******************************************************************************************
void AcMapOrclApiTestImportDlg::OnBtnBlocks() 
{
	std::vector<std::string> vectBlockNames;

	if (!AcMapOrclApiTestTools::GetListStringValuesFromTableColumn(
		"ADMPENTITIES",
		"BLOCKNAME",
		vectBlockNames))
	{
		return;
	}

	if (0==vectBlockNames.size())
	{
		AfxMessageBox("There is no block in this schema");
		return;
	}

	std::string strListValues;
	for (int i=0; i<vectBlockNames.size(); i++)
	{
		std::string strBlockAttributeTableName;
		std::vector<std::string> vectAttributeTableNames;
		CString strQueryAttributes;

		strQueryAttributes.Format(
			"select AllTables.TABLE_NAME "
			"from SYS.ALL_TABLES AllTables "
			"where AllTables.OWNER=(select usersTable.username from user_users usersTable) "
			"and AllTables.TABLE_NAME=CONCAT('ADMPBL', UPPER('%s'))",
			vectBlockNames[i].c_str());

		if (AcMapOrclApiTestTools::GetListStringValuesFromTable(
			"SYS.ALL_TABLES",
			(const char*)strQueryAttributes,
			vectAttributeTableNames))
		{
			if (0==vectAttributeTableNames.size())
			{
				strBlockAttributeTableName="No block attribute";
			}
			else
			{
				//there is normally only one string in the vector
				//because only one attribute table name pet block
				strBlockAttributeTableName=vectAttributeTableNames[0];
			}
		}

		strListValues+=vectBlockNames[i];
		strListValues+="\t";
		strListValues+=strBlockAttributeTableName;
		strListValues+="\r\n";
	}

	AcMapOrclApiTestDisplayTextDlg Dlg(
		"Block Names & Block Attributes",
		"Block name / Corresponding block attribute table name",
		strListValues);
	Dlg.DoModal();
}
